package jadean.ui.java.wizards;

import jadean.dean.Resource;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.jface.wizard.Wizard;


public class DependencyAnalyzerWizard extends Wizard {
	
	protected BasicInformationPage one;
	protected EntryPointPage two;
	protected ResultPage three;
	protected WizardInput input;

	public DependencyAnalyzerWizard(WizardInput input) {
		super();
		this.setWindowTitle("Dependency Analyzer for Java projects");
		this.setNeedsProgressMonitor(true);
		this.input = input;
	}

	@Override
	public void addPages() {
		three = new ResultPage(input);
		two = new EntryPointPage(input);
		one = new BasicInformationPage(input);
		addPage(one);
		addPage(two);
		addPage(three);
		
		input.notifyListeners();
		
	}

	@Override
	public boolean performFinish() {
		Set<Resource> delete = new HashSet<Resource>();
		for (Object o: three.getCheckedElements()) {
			delete.add((Resource) o);
		}
		input.getProject().removeResources(delete);
		return true;
	}
	
}

